<?php

namespace controller;

use ControllerScheme;
use model\Entity\DevicesEntity;
use model\Entity\UsersEntity;

class Notifications extends ControllerScheme {
	const name = 'نوتیفیکیشن';

	protected function add(?bool $csrf = true) {
		$userIds = $this->requestArray('user_id');
		$title = $this->requestArray('notification_title');
		$text = $this->requestArray('notification_text');
		$tokens = [];
		if (in_array('all', $userIds)) {
			$users = \model\Users::getAll();
			$tokens = \model\Users::Db()->where('firebase_token', 'is not', null)->get()->map(function (UsersEntity $devicesEntity) {
				return $devicesEntity->firebase_token;
			})->values()->all();
		} else {
			$users = \model\Users::Db()->whereIn('user_id', (array)$userIds)->get();
		}
		foreach ($users as $user) {

			if ($user instanceof UsersEntity && strlen($user->firebase_token . '') > 1) {
				$tokens[] = $user->firebase_token;
			}
		}
		$tokens = array_unique($tokens);
		foreach ($tokens as $token) {
			echo sendPushNotification($token, $title, null, $text) . '<br>';
		}

		return parent::add($csrf); // TODO: Change the autogenerated stub
	}
}