<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class BookmarksEntity extends EntityScheme {
	public $bookmark_id;
	/**
	 * انتخاب کاربر
	 **/
	public $user_id;
	/**
	 * انتخاب کتاب
	 **/
	public $book_id;
	/**
	 * انتخاب داستان
	 **/
	public $story_id;

	public function model() {
		return new \model\Bookmarks();
	}

	public function apiFormat() {
		$book = \model\Books::get($this->book_id);
		$story = \model\Stories::get($this->story_id);
		return [
			'id'    => $this->bookmark_id,
			'book'  => $book instanceof BooksEntity ? $book->apiFormat(true) : null,
			'story' => $story instanceof StoriesEntity ? $story->apiFormat(null,true) : null
		];
	}

	protected function dictionary(): array {
		return [
			'bookmark_id' => 'bookmark_id',
			'user_id'     => 'user_id',
			'book_id'     => 'book_id',
			'story_id'    => 'story_id',
		];
	}
}
