<?php
namespace model\Entity;
use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;
use model\Users;

class CommentsEntity extends EntityScheme {
    public $comment_id;
	public $user_id;
	public $rate;
	public $text;
	public $story_id;
	public $book_id;
	public $status;


    public function model() {
        return new \model\Comments();
    }

    public function toOption(): Option
    {
        $user_name = \model\Users::get($this->user_id)->name;
        return HtmlTags::Option()->Value($this->comment_id)->Content($user_name . " : " .$this->text);
    }

    public function apiFormat(): array {
        /** @var UsersEntity $user */
        $user = Users::get($this->user_id);

        return [
            'id'        => (int)$this->comment_id,
            'user'      => $user->commentFormat(),
            'rate'      => $this->rate,
            'text'      => $this->text,
            'createdAt' => strtotime($this->created_at) * 1000,
            'bookId' => $this->book_id,
            'storyId' => $this->story_id,
        ];
    }


    protected function dictionary(): array {
        return  [
            'comment_id' => 'comment_id',
            'user_id' => 'user_id',
            'rate' => 'comment_rate',
            'text' => 'comment_text',
            'story_id' => 'story_id',
            'book_id' => 'book_id',
            'status' => 'status',

        ];
    }
}
