<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Products;
use model\Services;

class OnboardingsEntity extends EntityScheme {
	use \FileUser;

	public $onboarding_id;
	/**
	 * عنوان صفحه
	 **/
	public $name;
	/**
	 * صفحه
	 **/
	public $file_id;
	/**
	 * توضیحات
	 **/
	public $details;

	public function model() {
		return new \model\Onboardings();
	}

	public function apiFormat(): array {
		return [
			'id'      => $this->onboarding_id,
			'name'    => $this->name,
			'file'    => $this->file()->apiFormat(),
			'details' => $this->details,
		];
	}

	protected function dictionary(): array {
		return [
			'onboarding_id' => 'onboarding_id',
			'name'          => 'onboarding_name',
			'file_id'       => 'file_id',
			'details'       => 'onboarding_details',
		];
	}
}
