<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Option;

class UserAddressesEntity extends EntityScheme {
	public $user_address_id;
	/**
	 * نام آدرس
	 **/
	public $address_name;
	/**
	 * آدرس
	 **/
	public $address_text;
	/**
	 * واحد و طبقه
	 **/
	public $address_floor;
	/**
	 * کد پستی
	 **/
	public $address_zip_code;
	/**
	 * شماره تماس
	 **/
	public $address_phone;
	public $user_id;

	public function model(): \model\UserAddresses {
		return new \model\UserAddresses();
	}

	public function toOption(): Option {
		return $this->__toOption('address_name');
	}

	public function apiFormat(): array {
		return [
			'id'        => $this->user_address_id,
			'title'     => $this->address_name,
			'address'   => $this->address_text,
			'floor'     => $this->address_floor,
			'plaque'    => $this->address_zip_code,
			'latitude'  => (double)0.0,
			'longitude' => (double)0.0,
			'phone'     => $this->address_phone,
		];
	}

	protected function dictionary(): array {
		return [
			'user_address_id'  => 'user_address_id',
			'address_name'     => 'user_address_name',
			'address_text'     => 'user_address_text',
			'address_floor'    => 'user_address_floor',
			'address_zip_code' => 'user_address_zip_code',
			'address_phone'    => 'user_address_phone',
			'user_id'          => 'user_user_id',
		];
	}
}
