<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\BooksEntity;
use model\Entity\OrdersEntity;
use model\Entity\ProductsEntity;
use View;

class Orders extends View {

	public $SingularName = 'سفارش';
	public $PluralName = 'سفارشات فروشگاه';

	public function main(Document &$document) {
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refresh()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Table('.table.table-bordered.table-striped')
													->Content(
														HtmlTags::Thead('.table-dark')
															->Content(
																HtmlTags::Tr()->Content(
																	HtmlTags::Th('ردیف')->Width('50'),
																	HtmlTags::Th('کد سفارش'),
																	HtmlTags::Th('کاربر'),
																	HtmlTags::Th('وضعیت'),
																	HtmlTags::Th('تاریخ ثبت'),
																	HtmlTags::Th('.no-sort عملیات')->Width('150')
																)
															),
														HtmlTags::Tbody()
															->Content(
																$this->show([
																	'order_id',
																	'user_id'      => function ($id) {
																		$user = \model\Users::get($id);
																		return $user->name . ' - ' . $user->mobile;
																	},
																	'order_status' => function ($status) {
																		return OrdersEntity::getStatusStatic($status);
																	},
																	'created_at',
																], false)
															)
													)
											)
									)
							)
						)
				);
	}

	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}

	public function Form() {

		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndBack()
											),
										$this->Html()->FormStart() .
										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('انتخاب کاربر') .
										$this->Html()->Select('user_id', 'user_id', \model\Users::toOption(), false, true, true) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('انتخاب آدرس') .
										$this->Html()->Select('user_address_id', 'user_address_id', \model\UserAddresses::toOption(), false, true, true) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(4) .
										$this->Html()->Label('وضعیت') .
										$this->Html()->Select('order_status', 'order_status', collect(OrdersEntity::$statusList)->map(function ($item, $key) {
											return HtmlTags::Option()->Value($key)->Content($item);
										})->join('')) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('هزینه ارسال') .
										$this->Html()->Price('order_fee', 'order_fee', '$', '', true, true) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('تخفیف') .
										$this->Html()->Price('order_discount', 'order_discount', '$', '', true, true) .
										$this->Html()->FormGroupEnd() .
										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('مجموع قیمت محصولات') .
										$this->Html()->Price('order_total', 'order_total', '$', '', true, true) .
										$this->Html()->FormGroupEnd() .


										$this->Html()->FormGroupStart(3) .
										$this->Html()->Label('مبلغ قابل پرداخت') .
										$this->Html()->Price('order_payable', 'order_payable', '$', '', true, true) .
										$this->Html()->FormGroupEnd() .

										$this->Html()->FormGroupStart(12) .
										$this->Html()->Label('محصولات') .
										$this->buildTable(),
										$this->Html()->FormGroupEnd() .


										$this->Html()->CardFooter()
									)
							)
						)
				);
	}

	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}

	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}

	private function buildTable(): \FwHtml\Elements\Tags\Table {
		$this->initDataTable = false;
		return HtmlTags::Table('.table.table-bordered.table-striped')->Content(
			HtmlTags::Thead()->Content(
				HtmlTags::Th()->Content("#"),
				HtmlTags::Th("محصول"),
				HtmlTags::Th("تعداد"),
			),
			HtmlTags::Tbody("#fieldsBody")->Content(
				function () {
					$data = $this->getData();
					if (isset($data)) {
						$products = json_decode($this->getData()->product_id . '', true);
						$output = [];
						if (is_array($products)) {
							$counter = 0;
							foreach ($products as $id => $count) {
								$counter++;
								$product = \model\Books::get($id);
								if ($product instanceof BooksEntity) {
									$output[] = HtmlTags::Tr()->Content(
										HtmlTags::Td()->Content(
//											HtmlTags::Td()->Content(
//												$counter.'',
//											),
											HtmlTags::Td()->Content(
												$product->name
											),
											HtmlTags::Td()->Content(
												$count.' عدد'
											),
										)
									);
								}
							}
						}
						return implode('', $output);
					}
					return "";
				}

			),
		);
	}


}
        